package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.richman;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.richman.dto.RichManCityDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.richman.dto.RichManUserDto;
import cn.com.duiba.tuia.commercial.center.api.dto.richman.RichManMapDto;
import cn.com.duiba.tuia.commercial.center.api.dto.richman.RichManMediaDto;

import java.util.List;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-12-03 21:42
 */
@AdvancedFeignClient
public interface RemoteRichManCityService {

    /**
     * 根据步数添加用户的城市记录
     */
    void addCityOption(RichManUserDto dto) throws BizException;

    /**
     * 获取城市列表
     * @param dto
     * @return
     */
    List<RichManCityDto>  getUsrCityList(RichManUserDto dto) throws BizException;

    /**
     * 获取城市媒体奖励
     * @param activityId
     * @param name
     * @return
     */
    List<RichManMediaDto> getMediaCityByCityName(Long activityId,String name,Long nowStep) throws BizException;

    /**
     * 修改媒体配置
     * @param dto
     */
    void updateMedia(RichManMediaDto dto) throws BizException;

    /**
     * 修改map配置
     * @param dto
     */
    void updateMap(RichManMapDto dto) throws  BizException;
}
