package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.*;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.FarmRankDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.*;

import java.util.List;

/**
 * RemoteFarmService
 *
 * @author huangruodan
 * @date 2019-12-03
 */

@AdvancedFeignClient
public interface RemoteFarmService {


    FarmDto initialize(FarmUserReq farmUserReq) throws BizException;

    /**
     * 互动上报
     *
     * @param activityReq 用户信息、上报类型
     * @return 奖励数量（激励互动时会有金币奖励，其他场景暂时没有）
     * @throws BizException
     */
    FarmReportActivityDto reportActivity(FarmReportActivityReq activityReq) throws BizException;

    /**
     * 记录用户心跳时间
     * @param heartbeatReq 心跳时间
     * @return 是否成功
     * @throws BizException
     */
    Boolean heartbeat(FarmHeartbeatReq heartbeatReq) throws BizException;


    /**
     * 新手引导监听接口
     *
     * @param guidanceReq
     * @return
     * @throws BizException
     */
    Boolean clickListener(NewUseGuidanceReq guidanceReq) throws BizException;


    /**
     * 消耗升级时用户是否翻倍
     * @param resultReq 用户
     * @return
     * @throws BizException
     */
    FarmDoubleRewardResultDto isDoubleRewardForUpgrade(FarmDoubleResultReq resultReq) throws BizException;

    /**
     *
     * @return
     * @throws BizException
     */
    FarmRewardCoinResultDto getCoinByReward(FarmRewardCoinReq farmRewardCoinReq) throws BizException;


    /**
     * 获取贡献任务
     * @param farmUserReq
     * @return
     * @throws BizException
     */
    List<FarmContributionUserMissionDto> getContributionList(FarmUserReq farmUserReq) throws BizException;


    /**
     * 记录视频次数
     * @param req
     * @return
     */
    Long recordVideoTimes(FarmUserReq req) throws BizException;


    /**
     * 查询视频次数
     * @param req
     * @return
     */
    Long queryVideoTimes(FarmUserReq req) throws BizException;

    /**
     * 查询等级任务list
     * @param farmUserReq
     * @return
     * @throws BizException
     */
    List<FarmContributionUserMissionDto> getLevelMissionList(FarmUserReq farmUserReq) throws BizException;


    /**
     * 渲染大转盘
     * @param req
     * @return
     * @throws BizException
     */
    FarmLotteryDto getLottery(FarmUserReq req) throws BizException;

    /**
     * 抽奖接口
     * @param req
     * @return
     * @throws BizException
     */
    FarmDrawResultDto drawPrize(FarmUserReq req) throws BizException;


    /**
     * 领取等级任务
     * @param farmLevelMissionReq
     * @return
     * @throws BizException
     */
    FarmContributionUserMissionDto receiveLevelMission(FarmLevelMissionReq farmLevelMissionReq) throws BizException;


    /**
     * 更新点击次数
     * @param req
     * @return
     * @throws BizException
     */
    boolean noticeClick(FarmUserReq req) throws BizException;


    /**
     * 领取额外的钻石
     * @param req
     * @return
     * @throws BizException
     */
    Long receiveVideoExtraCoin(FarmUserReq req) throws BizException;


    /**
     * 排行榜
     * @param req
     * @return
     * @throws BizException
     */
    FarmRankDto getRankInfo(FarmUserReq req) throws BizException;


    /**
     * @description <p>讯飞获取红包雨配置
     * @author cuiwx 2021/9/3
     * @return
     */
    FarmRedPacketRainDto redPacketRainConfig(FarmUserReq req) throws BizException;

    /**
     * @description <p>讯飞玩家添加钻石
     * @author cuiwx 2021/9/3
     * @return
     */
    FarmRedPacketRainObtainCoinDto redPacketRainObtainCoin(FarmUserReq req) throws BizException;
}
