package cn.com.duiba.tuia.commercial.center.api.constant.farm;

import lombok.Getter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @description <p>墨迹天气枚举
 * @author cuiwx
 * @version 1.0 2021/9/1
 */
@Getter
public enum WeatherEnum {

    SUNNY(0, "晴天"),
    CLOUDY(1, "阴天"),
    RAIN(2, "雨天"),
    SNOWY(3, "雪天"),
    ;
    private Integer value;
    private String desc;

    WeatherEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static Optional<WeatherEnum> of(Integer value) {
        return Arrays.stream(WeatherEnum.values()).filter(x -> Objects.equals(x.value, value)).findFirst();
    }

}