package cn.com.duiba.tuia.commercial.center.api.dto.farm.common;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 农场用户等级表
 */
@Getter
@Setter
@SuppressWarnings("serial")
@AllArgsConstructor
@NoArgsConstructor
public class FarmUserLevelDto implements Serializable {

    @ApiModelProperty(value = "主键")
    protected Long id;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "用户id")
    private Long baseUserId;

    @ApiModelProperty(value = "用户当前等级")
    private Integer currentLevel;

    @ApiModelProperty(value = "用户当前经验")
    private Long currentExp;

    @ApiModelProperty(value = "红包数量")
    private Integer seniorCurrency;

    @ApiModelProperty(value = "上次领取每日奖励的时间")
    private Date lastFetchGiftTime;

    @ApiModelProperty(value = "已经完成提现的等级")
    private String withdrawLevelRecord;

    @ApiModelProperty(value = "上次提现时间")
    private Date lastWithdrawTime;

    @ApiModelProperty(value = "上次提现时间")
    private Date lastLevelUpTime;

    public void setWithdrawLevelRecord(String withdrawLevelRecord) {
        this.withdrawLevelRecord = withdrawLevelRecord == null ? null : withdrawLevelRecord.trim();
    }

    public List<Integer> getwithdrawLevelList() {
        if (StringUtils.isBlank(this.withdrawLevelRecord)) {
            return Lists.newArrayList();
        }
        List<String> list = Splitter.on(",").splitToList(this.withdrawLevelRecord);
        return list.stream().map(Integer::valueOf).collect(Collectors.toList());

    }
}