package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmLandReq;

@AdvancedFeignClient
public interface RemoteFarmLandService {

    /**
     * 解锁土地
     *
     * @param req
     * @return
     */
    FarmDto unlockLand(FarmLandReq req) throws BizException;

    /**
     * @description
     * <p> 原先的解锁土地功能逻辑变更：
     *  1.购买果树/种子接口，只进行扣除钻石
     *  2.种植接口[土地解锁]，则进行实际的解锁逻辑，解锁之前需要判断土地是否已经扣除钻石，不可重复扣除
     * @author cuiwx
     * @version 1.0 2021/8/30
     * @return
     */
    FarmDto shopping(FarmLandReq req) throws BizException;

}
