package cn.com.duiba.tuia.commercial.center.api.dto.commercial.hb;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 还呗积分消耗配置
 *
 * @author zhangbaiqiang
 * @date 2019-06-24
 */
public class DeductScoreConfig implements Serializable {
    private static final long serialVersionUID = -6983242099115161230L;

    /**
     * 免费参与次数
     */
    private Integer freeTimes;

    /**
     * 扣除分值
     */
    private Integer score;

    /**
     * 额外参数
     */
    private Map<String,String> extInfo;


    /**
     * 媒体测试接口
     */
    private String deductScoreTestUrl;


    /**
     * 媒体线上接口
     */
    private String deductScoreOnlineUrl;


    /**
     * 通知测试接口
     */
    private String notifyTestUrl;

    /**
     * 通知线上结偶
     */
    private String notifyOnlineUrl;

    public Integer getFreeTimes() {
        return freeTimes;
    }

    public void setFreeTimes(Integer freeTimes) {
        this.freeTimes = freeTimes;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Map<String, String> getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(Map<String, String> extInfo) {
        this.extInfo = extInfo;
    }

    /**
     * 获取默认配置
     */
    public static DeductScoreConfig getDefault() {
        DeductScoreConfig config = new DeductScoreConfig();
        config.setFreeTimes(6);
        config.setScore(2);
        config.setExtInfo(new HashMap<>());
        return config;
    }

    public String getDeductScoreTestUrl() {
        return deductScoreTestUrl;
    }

    public void setDeductScoreTestUrl(String deductScoreTestUrl) {
        this.deductScoreTestUrl = deductScoreTestUrl;
    }

    public String getDeductScoreOnlineUrl() {
        return deductScoreOnlineUrl;
    }

    public void setDeductScoreOnlineUrl(String deductScoreOnlineUrl) {
        this.deductScoreOnlineUrl = deductScoreOnlineUrl;
    }

    public String getNotifyTestUrl() {
        return notifyTestUrl;
    }

    public void setNotifyTestUrl(String notifyTestUrl) {
        this.notifyTestUrl = notifyTestUrl;
    }

    public String getNotifyOnlineUrl() {
        return notifyOnlineUrl;
    }

    public void setNotifyOnlineUrl(String notifyOnlineUrl) {
        this.notifyOnlineUrl = notifyOnlineUrl;
    }

    @Override
    public String toString() {
        return "DeductScoreConfig{" +
                "freeTimes=" + freeTimes +
                ", score=" + score +
                ", extInfo=" + extInfo +
                ", deductScoreTestUrl='" + deductScoreTestUrl + '\'' +
                ", deductScoreOnlineUrl='" + deductScoreOnlineUrl + '\'' +
                ", notifyTestUrl='" + notifyTestUrl + '\'' +
                ", notifyOnlineUrl='" + notifyOnlineUrl + '\'' +
                '}';
    }
}
