package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * @author lijicong
 * @since 2020-05-28
 */
@Setter
@Getter
public class ActivityRequestDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "设备id")
    private String deviceId;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "活动用户id")
    private Long consumerId;

    @ApiModelProperty(value = "活动id")
    private Long activityId;

    @ApiModelProperty(value = "广告位id")
    private Long slotId;

    @ApiModelProperty(value = "媒体用户Id")
    private String mediaUserId;

    @ApiModelProperty(value = "皮肤版本")
    private Integer skinVersion;

    @ApiModelProperty(value = "ip", hidden = true)
    private String ip;

    @ApiModelProperty(value = "request id , 每次进入广告位后由open-web 生成", hidden = true)
    private String rid;

    @ApiModelProperty(value = "user-agent", hidden = true)
    private String ua;

    @ApiModelProperty(value = "定制参数")
    private Map<String, String> extParamMap;
}
