package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 可以选择对类功能进行说明
 * Created by zxw on 2020-06-01.
 */

@Getter
@Setter
public class SynMissionDTO implements Serializable {

    @ApiModelProperty(value = "任务id")
    private Long missionId;

    @ApiModelProperty(value = "活动id")
    private Integer activityId;

    @ApiModelProperty(value = "0 未完成, 1已完成")
    private Integer status;

    @ApiModelProperty(value = "任务名称")
    private String title;

    @ApiModelProperty(value = "当前值")
    private Integer currentNum;

    @ApiModelProperty(value = "任务种类 1:签到任务 2:历程任务 3:每日任务")
    @ExcelRowIndex(1)
    private Integer missionCat;

    @ApiModelProperty(value = "任务类型(不同类型针对不同字段)")
    @ExcelRowIndex(2)
    private Integer missionType;

    @ApiModelProperty(value = "目标值")
    @ExcelRowIndex(3)
    private Integer targetNum;

    @ApiModelProperty(value = "任务奖励")
    @ExcelRowIndex(4)
    private Long missionPrize;

    @ApiModelProperty(value = "任务描述")
    @ExcelRowIndex(5)
    private String description;

    @ApiModelProperty(value = "任务排序")
    private Integer missionOrder;


}
