package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.RandomUtils;

import java.io.Serializable;

/**
 * 各种活动纬度的配置汇总
 *
 * @author lijicong
 * @since 2020-06-11
 */
@Setter
@Getter
public class SynActivityConfigDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "活动id")
    private Long activityId;

    @ApiModelProperty(value = "打开礼包后出券开关")
    private Boolean openGiftDropCouponSwitch = false;

    @ApiModelProperty(value = "新人三日礼开关")
    private Boolean thirdGiftsSwitch = true;

    @ApiModelProperty(value = "每日限次活动-广告概率配置")
    private AdTypeProb dayActivityAdTypeProb = new AdTypeProb();

    @ApiModelProperty(value = "每日抽奖-广告概率配置")
    private AdTypeProb dayLotteryAdTypeProb = new AdTypeProb();

    @ApiModelProperty(value = "图鉴翻倍-广告概率配置")
    private AdTypeProb foodDoubleAdTypeProb = new AdTypeProb();

    @ApiModelProperty(value = "现金翻倍-广告概率配置")
    private AdTypeProb cashDoubleAdTypeProb = new AdTypeProb();

    @ApiModelProperty(value = "金币翻倍-广告概率配置")
    private AdTypeProb coinDoubleAdTypeProb = new AdTypeProb();


    // 广告活动分为激励互动、激励视频、原生激励，概率配置
    @Setter
    @Getter
    public static class AdTypeProb implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "激励互动")
        private Integer interact = 40;

        @ApiModelProperty(value = "激励视频")
        private Integer video = 30;

        @ApiModelProperty(value = "原生激励")
        private Integer original = 30;

        public String getRandomType() {
            Integer target = RandomUtils.nextInt(0, 101);
            if (target < interact) {
                return "interact";
            }
            if (target < interact + video) {
                return "video";
            }
            return "original";
        }

    }

    public static void main(String[] args) {
        SynActivityConfigDTO dto = new SynActivityConfigDTO();
        System.out.println(dto.getCashDoubleAdTypeProb().getRandomType());
    }

}
