package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 用户的
 * Created by zxw on 2020-06-01.
 */

@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SynInitCashDTO implements Serializable {

    @ApiModelProperty(value = "是否有新人奖励")
    private Boolean withNew;

    @ApiModelProperty(value = "新人三日礼")
    private List<Integer> newCash;

    /**
     * 为了减少查询表，当这边低于3的时候会去查询cash表
     */
    @ApiModelProperty(value = "新人礼步数")
    private Integer step;

    @ApiModelProperty(value = "新人三日礼的最新领取日期")
    private Date date;

    @ApiModelProperty(value = "今日是否领取过")
    private Boolean isReceived;

    @ApiModelProperty(value = "新手指引金额")
    private Integer initCash;

    @ApiModelProperty(value = "新手奖励的总金额（冗余字段，为了方便计算）")
    private Integer totalAmount;

}
