package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-05-27
 */
@Setter
@Getter
public class SynthesisDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户信息")
    private SynUserDTO user;

    @ApiModelProperty(value = "用户现金信息")
    private SynUserCashDTO userCash;

    @ApiModelProperty(value = "用户离线金币收益")
    private OfflineGoldDTO offlineGold;

    @ApiModelProperty(value = "宠物信息")
    private List<SynPetDTO> pets;

    @ApiModelProperty(value = "可购宠物")
    private QuickBuyInfoDTO quickBuyInfo;

    @ApiModelProperty(value = "用户三日礼")
    private SynInitCashDTO thirdGift;

    @ApiModelProperty(value = "是否领取过天降礼包")
    private Boolean heavenGift;

    @ApiModelProperty(value = "美食场景")
    private SynFoodSceneDTO foodScene;

    @Setter
    @Getter
    public static class QuickBuyInfoDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "可购宠物ID")
        private Long buyPetId;

        @ApiModelProperty(value = "可购宠物等级")
        private Integer buyPetGrade;

        @ApiModelProperty(value = "宠物价格")
        private Long petPrice;
    }

    @Setter
    @Getter
    public static class OfflineGoldDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "离线收益时长/小时")
        private Long offlineTime;

        @ApiModelProperty(value = "离线收益")
        private Long coin;

        @ApiModelProperty(value = "奖励")
        private SynRewardDTO reward;

    }

    @Setter
    @Getter
    public static class SynFoodSceneDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "气泡文字")
        private String popText;

        @ApiModelProperty(value = "场景图片")
        private String sceneImg;

    }
}
