package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.spike;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spike.CommercialSpikeInitInfoDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spike.CommercialSpikeResultDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spike.req.CommercialUserSpikeCallBackReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spike.req.CommercialUserSpikeReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.story.spike.StoryUserSpikePrizeDto;

import java.util.List;

/**
 * RemoteCommercialSpikeService
 *
 * @author huangruodan
 * @date 2019-08-25
 */

@AdvancedFeignClient
public interface RemoteCommercialSpikeService {

    /**
     * 获取用户秒杀初始页面信息
     * @param req 请求参数
     * @return 秒杀信息
     * @throws BizException 业务异常
     */
    CommercialSpikeInitInfoDto spikeInfoInit(CommercialUserReq req) throws BizException;


    /**
     * 秒杀中奖和已经抽奖中现金红包的用户列表
     * @param req 请求参数(媒体信息，设备信息)
     * @return 中奖名单
     * @throws BizException 业务异常
     */
    List<StoryUserSpikePrizeDto> getPrizeList(CommercialUserReq req) throws BizException;

    /**
     * 用户秒杀
     * @param spikeReq 用户信息(媒体信息，设备信息)、秒杀itemId
     * @return 是否扣除库存成功、recordId、剩余库存
     * @throws BizException 业务异常
     */
    CommercialSpikeResultDto userSpike(CommercialUserSpikeReq spikeReq) throws BizException;

    /**
     * 秒杀抽奖订单回调
     * @param req 参数(用户数据,订单id,秒杀记录id)
     * @throws BizException 业务异常
     * @return 是否成功
     */
    Boolean spikeOrderCallBack(CommercialUserSpikeCallBackReq req) throws BizException;
}
