package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/3/3
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum DomainOperateEnum implements LabelAndValue<Integer>{
    /**
     * 新增域名
     */
    ADD_DOMAIN(1, "新增域名"),
    /**
     * 同步域名
     */
    SYNC_DOMAIN(2, "同步域名"),
    /**
     * 申请域名
     */
    APPLY_DOMAIN(3, "申请域名"),
    /**
     * 下线域名
     */
    OFF_LINE_DOMAIN(4, "下线域名"),
    /**
     * 删除域名
     */
    DELETE_DOMAIN(5, "删除域名"),
    ;


    private final Integer value;
    private final String label;

    DomainOperateEnum(Integer value, String label) {
        this.value = value;
        this.label = label;
    }


    public static DomainOperateEnum getInstanceByValue(Integer value){
        for (DomainOperateEnum domainOperateEnum : DomainOperateEnum.values()){
            if(domainOperateEnum.getValue().equals(value)){
                return domainOperateEnum;
            }
        }
        return null;
    }


}
