package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import lombok.Getter;
/**
 * @description     <p>域名使用记录审批状态
 * @author cuiwx
 * @version 1.0 2022/3/4
 */
@Getter
public enum ENAuditStatus implements LabelAndValue<Integer>{
    AUDIT_UNFINISHED(0, "审核拒绝"),
    AUDIT_FINISHED(1, "审核通过"),
    AUDIT_PROGRESS(2, "审核中"),
    ;
    private final Integer value;
    private final String label;

    ENAuditStatus(Integer value, String label) {
        this.value = value;
        this.label = label;
    }
}
