package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>业务空间
 * @author cuiwx
 * @version 1.0 2022/3/3
 */
@Getter
public enum ENBusinessSpace implements LabelAndValue<Integer>{
    MEDIA(1,"流量线"),
    ADVERT(2,"广告线"),
    FRONT_END(3,"前端"),
    SYS_MASTER_STATION(4,"系统主站"),
    ;

    private final Integer value;
    private final String label;

    ENBusinessSpace(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENBusinessSpace enBusinessSpace = Arrays.stream(ENBusinessSpace.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enBusinessSpace)) {
            return StrUtil.EMPTY;
        }
        return enBusinessSpace.getLabel();
    }

    public static ENBusinessSpace getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENBusinessSpace.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }
}
