package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>业务类型
 * @author cuiwx
 * @version 1.0 2022/3/3
 */
@Getter
public enum ENBusinessType implements LabelAndValue<Integer>{
    ADD_RECORD(1,"添加记录"),
    ADD_RECORD_AND_SYN(2,"添加记录并同步到业务平台"),
    ;

    private final Integer value;
    private final String label;

    ENBusinessType(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENBusinessType enBusinessType = Arrays.stream(ENBusinessType.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enBusinessType)) {
            return StrUtil.EMPTY;
        }
        return enBusinessType.getLabel();
    }
}
