package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
/**
 * @description     <p>域名状态
 * @author cuiwx
 * @version 1.0 2022/2/25
 */
@Getter
public enum ENDeleted implements LabelAndValue<Integer>{
    ONLINE(0,"上线"),
    OFFLINE(1,"下线"),
    APPROVAL(2,"审批中"),
    ;

    private final Integer value;
    private final String label;

    ENDeleted(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENDeleted enDeleted = Arrays.stream(ENDeleted.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enDeleted)) {
            return StrUtil.EMPTY;
        }
        return enDeleted.getLabel();
    }
}
