package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>域名场景对应关系
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
@Getter
public enum ENDomainScene implements LabelAndValue<Integer>{

    DOMAIN_SCENE_1(1,1,0,"流量线-程序化-ADX-落地页域名"),
    DOMAIN_SCENE_2(2,1,0,"流量线-程序化-ADX-素材"),
    DOMAIN_SCENE_3(3,1,0,"流量线-程序化-ADX-监测链接"),
    DOMAIN_SCENE_4(4,1,0,"流量线-程序化-开户-ocpx-授权回调地址"),
    DOMAIN_SCENE_5(5,1,0,"流量线-程序化-开户-ocpx-曝光点击中转"),
    DOMAIN_SCENE_6(6,1,0,"流量线-程序化-开户-监测链接"),
    DOMAIN_SCENE_7(7,1,0,"流量线-程序化-开户-媒体RTA"),
    DOMAIN_SCENE_8(8,1,5,"流量线-非程序化-微信/支付宝-扫码-短链入口"),
    DOMAIN_SCENE_9(9,1,6,"流量线-非程序化-微信/支付宝-扫码-短链拦截"),
    DOMAIN_SCENE_10(10,1,3,"流量线-非程序化-微信/支付宝-小程序代理域名"),
    DOMAIN_SCENE_11(11,1,1,"流量线-非程序化-投放域名"),
    DOMAIN_SCENE_12(12,1,1,"流量线-非程序化-活动域名"),
    DOMAIN_SCENE_13(13,1,0,"流量线-非程序化-接口-素材API"),
    DOMAIN_SCENE_14(14,1,0,"流量线-非程序化-接口-投放API"),
    DOMAIN_SCENE_15(15,1,0,"流量线-非程序化-接口-点击曝光上报API"),
    DOMAIN_SCENE_16(16,1,0,"流量线-非程序化-接口-展示广告API"),
    DOMAIN_SCENE_17(17,1,0,"流量线-非程序化-接口-互动直投API"),
    DOMAIN_SCENE_18(18,1,0,"流量线-非程序化-接口-虚拟奖品API"),
    DOMAIN_SCENE_19(19,1,0,"流量线-非程序化-接口-任务上报API"),
    DOMAIN_SCENE_20(20,1,0,"流量线-非程序化-接口-数据收益API"),
    DOMAIN_SCENE_21(21,1,0,"创新线-活动-互动页面"),
    DOMAIN_SCENE_22(22,1,0,"创新线-活动-兜底页面"),
    DOMAIN_SCENE_23(23,2,4,"广告线-自建站-百奇落地页"),
    DOMAIN_SCENE_24(24,2,4,"广告线-自建站-百奇收银台"),
    DOMAIN_SCENE_25(25,2,4,"广告线-自建站-积木落地页"),
    DOMAIN_SCENE_26(26,2,4,"广告线-小程序-小程序中间域名"),
    DOMAIN_SCENE_27(27,2,0,"广告线-广告主回传-回传转化数据"),
    DOMAIN_SCENE_28(28,3,0,"前端-CDN"),
    DOMAIN_SCENE_29(29,3,0,"前端-错误上报"),
    DOMAIN_SCENE_30(30,3,0,"前端-微信下载相关接口"),
    DOMAIN_SCENE_31(31,3,0,"前端-埋点接口"),
    DOMAIN_SCENE_32(32,3,0,"前端-落地页埋点接口"),
    DOMAIN_SCENE_33(33,3,0,"前端-狩猎埋点上报接口"),
    DOMAIN_SCENE_34(34,3,0,"前端-百奇落地页心跳埋点"),
    DOMAIN_SCENE_35(35,3,0,"前端-风控接口"),
    DOMAIN_SCENE_36(36,3,0,"前端-风控落地页巡查"),
    DOMAIN_SCENE_37(37,4,0,"数据线内部系统-数据线内部系统-DMP-DMP系统主站域名"),
    DOMAIN_SCENE_38(38,4,0,"数据线内部系统-数据线内部系统-火眼-火眼系统主站域名"),
    DOMAIN_SCENE_39(39,4,0,"数据线内部系统-数据线内部系统-元数据-元数据系统主站域名"),
    DOMAIN_SCENE_40(40,4,0,"数据线内部系统-数据线内部系统-HUE-HUE系统主站域名"),
    DOMAIN_SCENE_41(41,4,0,"数据线内部系统-数据线内部系统-玲珑-调度任务1"),
    DOMAIN_SCENE_42(42,4,0,"数据线内部系统-数据线内部系统--调度任务2"),
    DOMAIN_SCENE_43(43,4,0,"数据线内部系统-数据线内部系统-hadoop管理平台"),
    DOMAIN_SCENE_44(44,4,0,"数据线内部系统-数据线内部系统-yarn任务管理平台"),
    DOMAIN_SCENE_45(45,4,0,"数据线内部系统-数据线内部系统-yarn历史任务管理平台"),
    DOMAIN_SCENE_46(46,4,0,"流量线系统-流量线系统-集团官网"),
    DOMAIN_SCENE_47(47,4,0,"流量线系统-流量线系统-媒体管理后台"),
    DOMAIN_SCENE_48(48,4,0,"流量线系统-流量线系统-媒体业务平台"),
    DOMAIN_SCENE_49(49,4,0,"流量线系统-流量线系统-盘古"),
    DOMAIN_SCENE_50(50,4,0,"流量线系统-流量线系统-CRM"),
    DOMAIN_SCENE_51(51,4,0,"流量线系统-流量线系统-实验平台"),
    DOMAIN_SCENE_52(52,4,0,"流量线系统-流量线系统-火眼"),
    DOMAIN_SCENE_53(53,4,0,"流量线系统-流量线系统-火眼手机端"),
    DOMAIN_SCENE_54(54,4,0,"流量线系统-流量线系统-元数据"),
    DOMAIN_SCENE_55(55,4,0,"流量线系统-流量线系统-DMP"),
    DOMAIN_SCENE_56(56,4,0,"流量线系统-流量线系统-用户研究平台"),
    DOMAIN_SCENE_57(57,4,0,"广告线系统-广告线系统-风控管理平台"),
    DOMAIN_SCENE_58(58,4,0,"广告线系统-广告线系统-推啊官网&代理商(备用)"),
    DOMAIN_SCENE_59(59,4,0,"广告线系统-广告线系统-推啊官网&代理商"),
    DOMAIN_SCENE_60(60,4,0,"广告线系统-广告线系统-百奇管理后台(备用)"),
    DOMAIN_SCENE_61(61,4,0,"广告线系统-广告线系统-百奇管理后台"),
    DOMAIN_SCENE_62(62,4,0,"广告线系统-广告线系统-百奇上架后台(备用)"),
    DOMAIN_SCENE_63(63,4,0,"广告线系统-广告线系统-百奇商家后台"),
    DOMAIN_SCENE_64(64,4,0,"广告线系统-广告线系统-百奇落地页"),
    DOMAIN_SCENE_65(65,4,0,"广告线系统-广告线系统-百奇落地页(备用)"),
    DOMAIN_SCENE_66(66,4,0,"广告线系统-广告线系统-未知"),
    DOMAIN_SCENE_67(67,4,0,"广告线系统-广告线系统-广告管理后台"),
    DOMAIN_SCENE_68(68,4,0,"广告线系统-广告线系统-广告管理后台H5"),
    DOMAIN_SCENE_69(69,4,0,"广告线系统-广告线系统-内部接口使用系统"),
    DOMAIN_SCENE_70(70,4,0,"广告线系统-广告线系统-积木建站"),
    DOMAIN_SCENE_71(71,4,0,"广告线系统-广告线系统-nezha管理后台"),
    DOMAIN_SCENE_72(72,4,0,"广告线系统-广告线系统-钟馗"),
    DOMAIN_SCENE_73(73,4,0,"广告线系统-广告线系统-奇货管理后台"),
    DOMAIN_SCENE_74(74,4,0,"广告线系统-广告线系统-无法访问"),
    DOMAIN_SCENE_75(75,4,0,"广告线系统-广告线系统-积木"),
    DOMAIN_SCENE_76(76,4,0,"广告线系统-广告线系统-sso"),
    DOMAIN_SCENE_77(77,4,0,"前端内部系统-前端内部系统-苍穹"),
    DOMAIN_SCENE_78(78,4,0,"前端内部系统-前端内部系统-天眼"),
    DOMAIN_SCENE_79(79,4,0,"前端内部系统-前端内部系统-百川"),
    DOMAIN_SCENE_80(80,4,0,"前端内部系统-前端内部系统-云帆"),
    DOMAIN_SCENE_81(81,4,0,"前端内部系统-前端内部系统-yapi接口管理"),
    DOMAIN_SCENE_82(82,4,0,"前端内部系统-前端内部系统-狩猎"),
    DOMAIN_SCENE_83(83,4,0,"测试内部系统-测试内部系统-云测"),
    DOMAIN_SCENE_84(84,4,0,"测试内部系统-测试内部系统-域名巡查"),
    ;

    private final Integer value;
    /**
     * 业务空间
     * {@link ENBusinessSpace}
     */
    private final Integer space;
    /**
     * 平台
     * {@link ENPlatForm}
     */
    private final Integer platForm;
    private final String label;

    ENDomainScene(Integer value, Integer space,Integer platForm,String label) {
        this.value = value;
        this.space=space;
        this.platForm=platForm;
        this.label = label;
    }

    public static ENDomainScene getEnumByValue(Integer value, Integer space) {
        if (Objects.isNull(value) || Objects.isNull(space)) {
            return null;
        }
        return Arrays.stream(ENDomainScene.values())
                .filter(x -> Objects.equals(value, x.getValue())
                        && Objects.equals(space, x.getSpace()))
                .findFirst().orElse(null);
    }
}
