package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>域名来源
 * @author cuiwx
 * @version 1.0 2022/2/25
 */
@Getter
public enum ENDomainSource implements LabelAndValue<Integer> {

    SHORT_PERIOD(0, "短期"),
    LONG_PERIOD(1, "长期"),
    ;
    private final Integer value;
    private final String label;

    ENDomainSource(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENDomainSource enDomainSource = Arrays.stream(ENDomainSource.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enDomainSource)) {
            return StrUtil.EMPTY;
        }
        return enDomainSource.getLabel();
    }

    public static ENDomainSource getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENDomainSource.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }
}
