package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import lombok.Getter;

/**
 * @description     <p>域名数据同步来源
 * @author cuiwx
 * @version 1.0 2022/3/1
 */
@Getter
public enum ENDomainSynDataSource implements LabelAndValue<Integer> {
    SOURCE_OUTSIDE(0, "同步数据到三方系统"),
    SOURCE_INSIDE(1, "三方系统响应同步结果"),
    ;
    private final Integer value;
    private final String label;

    ENDomainSynDataSource(Integer value, String label) {
        this.value = value;
        this.label = label;
    }
}
