package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>域名数据同步状态
 * @author cuiwx
 * @version 1.0 2022/3/1
 */
@Getter
public enum ENDomainSynDataState implements LabelAndValue<Integer> {

    DOMAIN_ADD(1, "新增数据", "domainSynDataAddStateServiceImpl"),
    DOMAIN_DELETED(2, "删除数据", "domainSynDataDeletedStateServiceImpl"),
    ;

    private final Integer value;
    private final String label;
    private final String beanName;

    ENDomainSynDataState(Integer value, String label, String beanName) {
        this.value = value;
        this.label = label;
        this.beanName = beanName;
    }

    public static ENDomainSynDataState getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENDomainSynDataState.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }
}
