package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>域名表域名同步状态
 * @author cuiwx
 * @version 1.0 2022/3/4
 */
@Getter
public enum ENDomainSynState implements LabelAndValue<Integer>{

    SYN_UNFINISHED(0, "未同步"),
    SYN_FINISHED(1, "同步完成"),
    SYN_PROGRESS(2, "同步中"),
    ;
    private final Integer value;
    private final String label;

    ENDomainSynState(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

//    public ArrayList<Integer> gainDomainSynStateExcludeSynFinished(){
//        return Arrays.stream(ENDomainSynState.values()).map(x->{if(!Objects.equals(x.getValue(),ENDomainSynState.SYN_FINISHED.getValue()))});
//
//    }
}
