package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>域名类型
 * @author cuiwx
 * @version 1.0 2022/3/1
 */
@Getter
public enum ENDomainType implements LabelAndValue<Integer> {
    INDEX_ACTIVITY(null, 1, "投放"),
    ACTIVITY_INDEX(null, 2, "活动"),
    LAND_PAGE(null, 3, "落地页"),
    ACTIVITY_GAMING(null, 4, "游戏"),
    BAI_QI_LAND_PAGE(4, 1, "百奇落地页面"),
    JI_MU_LAND_PAGE(4, 2, "积木落地页"),
    ;

    private final Integer value;
    private final Integer platForm;
    private final String label;

    ENDomainType(Integer platForm, Integer value, String label) {
        this.platForm = platForm;
        this.value = value;
        this.label = label;
    }

    // todo: cuiwx 2022/3/2 9:40 上午 降级处理
    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENDomainType enDomainType = Arrays.stream(ENDomainType.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enDomainType)) {
            return StrUtil.EMPTY;
        }
        return enDomainType.getLabel();
    }

    // todo: cuiwx 2022/3/2 2:01 下午  根据平台来
    public static ENHttpType getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENHttpType.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }
}
