package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
/**
 * @description     <p>是否有Http证书
 * @author cuiwx
 * @version 1.0 2022/2/25
 */
@Getter
public enum ENHttpType implements LabelAndValue<Integer> {
    HTTP(0, "否", "HTTP"),
    HTTPS(1, "是", "HTTPS"),
    ;
    private final Integer value;
    private final String label;
    private final String desc;

    ENHttpType(Integer value, String label, String desc) {
        this.value = value;
        this.label = label;
        this.desc = desc;
    }

    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENHttpType enHttpType = Arrays.stream(ENHttpType.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enHttpType)) {
            return StrUtil.EMPTY;
        }
        return enHttpType.getLabel();
    }

    public static ENHttpType getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENHttpType.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }
}
