package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>域名下线类型
 * @author cuiwx
 * @version 1.0 2022/3/4
 */
@Getter
public enum ENOfflineOperateType  implements LabelAndValue<Integer>{
    DIRECT_OFFLINE(1,"直接下线"),
    DING_DING_CONFIRM(2,"钉钉消息逐一确认"),
    ;

    private final Integer value;
    private final String label;

    ENOfflineOperateType(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

    public static ENOfflineOperateType getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENOfflineOperateType.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }
}
