package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.com.duiba.tuia.domain.manager.api.model.internal.*;
import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @description     <p>平台枚举
 * @author cuiwx
 * @version 1.0 2022/3/1
 */
@Getter
public enum ENPlatForm implements LabelAndValue<Integer> {
    OTHER(1, SynDataWithOutReq.class, "其他平台"),
    SSP_DOMAIN(2, SynDataSspDomainReq.class, "媒体管理后台-域名管理"),
    SSP_WE_CHAT_DOMAIN_PROXY(3, SynDataSspWeChatDomainProxyReq.class, "媒体管理后台-小程序代理域名"),
    ZHONG_KUI_DOMAIN(4, SynDataZhongKuiDomainReq.class, "钟馗"),
    US_SHORT_URL(5, SynDataUsShortUrlReq.class, "星盟台-短链入口"),
    US_SHORT_URL_BREAK(6, SynDataUsShortUrlBreakReq.class, "星盟台-短链拦截入口"),
    ;

    private final Integer value;
    private final Class reqClazz;
    private final String label;

    ENPlatForm(Integer value, Class reqClazz, String label) {
        this.value = value;
        this.reqClazz = reqClazz;
        this.label = label;
    }

    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENPlatForm enPlatForm = Arrays.stream(ENPlatForm.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enPlatForm)) {
            return StrUtil.EMPTY;
        }
        return enPlatForm.getLabel();
    }

    public static ENPlatForm getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENPlatForm.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }

    public static DomainSynDataBaseBean getReqBean(Integer platForm) {
        ENPlatForm enPlatForm = Optional.ofNullable(ENPlatForm.getEnumByValue(platForm)).orElse(ENPlatForm.OTHER);
        try {
            return (DomainSynDataBaseBean) enPlatForm.getReqClazz().newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
