package cn.com.duiba.tuia.domain.manager.api.constant.enums;

import cn.hutool.core.util.StrUtil;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description     <p>是否枚举
 * @author cuiwx
 * @version 1.0 2022/3/1
 */
@Getter
public enum ENYesOrNo implements LabelAndValue<Integer> {
    NO(0, "否"),
    YES(1, "是"),
    ;

    private final Integer value;
    private final String label;

    ENYesOrNo(Integer value, String label) {
        this.value = value;
        this.label = label;
    }

    public static String getLabelByValue(Integer value) {
        if (Objects.isNull(value)) {
            return StrUtil.EMPTY;
        }
        ENYesOrNo enYesOrNo = Arrays.stream(ENYesOrNo.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
        if (Objects.isNull(enYesOrNo)) {
            return StrUtil.EMPTY;
        }
        return enYesOrNo.getLabel();
    }

    public static ENYesOrNo getEnumByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Arrays.stream(ENYesOrNo.values())
                .filter(x -> Objects.equals(value, x.getValue()))
                .findFirst().orElse(null);
    }
}
