package cn.com.duiba.tuia.domain.manager.api.constant.enums;


import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @description     <p>枚举类持有者
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
public class EnumContextHolder {
    /**
     * 枚举类字典
     */
    private static Map<String, Class<? extends Enum<?>>> enumMap = new ConcurrentHashMap<>();

    static {
        enumMap.put("ENBusinessType", ENBusinessType.class);
        enumMap.put("ENDeleted", ENDeleted.class);
        enumMap.put("ENDomainScene", ENDomainScene.class);
        enumMap.put("ENDomainSource", ENDomainSource.class);
        enumMap.put("ENDomainSynDataSource", ENDomainSynDataSource.class);
        enumMap.put("ENDomainSynDataState", ENDomainSynDataState.class);
        enumMap.put("ENDomainType", ENDomainType.class);
        enumMap.put("ENHttpType", ENHttpType.class);
        enumMap.put("ENPlatForm", ENPlatForm.class);
        enumMap.put("ENYesOrNo", ENYesOrNo.class);
    }

    public static Enum<?>[] gainAllEnums(String dictionary) {
        Class<? extends Enum<?>> clazz = enumMap.get(dictionary);
        if (Objects.isNull(clazz)) {
            return new Enum[0];
        }
        return clazz.getEnumConstants();
    }

}
