/**
 * 文件名： ErrorCode.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午10:15:33
 */
package cn.com.duiba.tuia.domain.manager.api.constant.enums;

/**
 * 此类描述的是： 推啊core工程内部自定义错误码规范<br>
 * 错误码组成：AABBCCC
 * <ul>
 * AA：模块编号
 * <li>00：公用模块</li>
 * <li>01：媒体模块</li>
 * <li>02：用户模块</li>
 * <li>03：媒体模块</li>
 * <li>04：广告位模块</li>
 * <li>05：数据模块</li>
 * </ul>
 * <ul>
 * BB：错误类型
 * <li>01 - 媒体级错误（参数错误）</li>
 * <li>02 - 业务级错误（service自身错误）</li>
 * <li>03 - 依赖级错误（service调用第三方服务错误）</li>
 * <li>04 - 交互级业务提醒（正常业务逻辑，非错误，需告知用户，如库存不足）</li>
 * </ul>
 * <ul>
 * CCC:具体错误码 举例
 * <li>通用的成功状态码：000</li>
 * <li>通用的未知错误码：999</li>
 * </ul>
 * <ul>
 * 业务前缀
 * <li>tuia-core：TC_</li>
 * </ul>
 *
 * @规范： http://cf.dui88.com/pages/viewpage.action?pageId=3544570
 * @汇总文档：http://cf.dui88.com/pages/viewpage.action?pageId=3560274
 */
public enum ErrorCode {

    /** 成功. */
    E0000000("0", "成功"),

    /** dubbo接口调用失败 */
    E0000001("0000001", "dubbo接口调用失败"),

    /** 请重新登录. */
    E9999998("9999998", "请重新登录"),

    E9999999("9999999", "未知错误"),

    /** 数据库异常. */
    E0100001("0100001", "数据库异常"),

    /** 参数错误. */
    E0100002("0100002", "参数错误"),

    /** MD5解密失败. */
    E0100003("0100003", "MD5解密失败"),

    /** 验证码校验失败. */
    E0100004("0100004", "验证码校验失败"),

    /** 文件不存在. */
    E0100204("0100204", "文件不存在"),

    /** 上传文件类型不符. */
    E0100005("0100005", "上传文件类型不符"),

    E0100206("0100206", "文件超过限制大小"),

    /** 上传文件太大. */
    E0100006("0100006", "上传文件太大"),

    /** 编码异常. */
    E0100007("0100007", "编码异常"),

    /** 发送短信验证码失败. */
    E0002008("0002008", "发送短信验证码失败"),

    /** 用户不存在. */
    E0102001("0102001", "用户不存在"),

    /** OSS上传文件失败. */
    E0110007("0110007", "OSS上传文件失败"),

    /** 文件不存在. */
    E0110008("0110008", "文件不存在"),

    /** 对象拷贝失败. */
    E0110009("0110009", "对象拷贝失败"),

    /** 生成.csv文件失败. */
    E0110010("0110010", "生成.csv文件失败"),

    /** 必须指定查询时间范围 */
    E0104011("0104011", "请指定时间范围"),

    // 用户模块
    /** 该用户不存在. */
    E0200000("0200000", "该用户不存在"),

    /** 用户名或密码错误. */
    E0200001("0200001", "用户名或密码错误"),

    /** 已经审核过. */
    E0200002("0200002", "已经审核过"),

    /** 审核媒体账号失败， 参数(审核不通过原因)为空. */
    E0200003("0200003", "审核媒体账号失败， 参数(审核不通过原因)为空"),

    /** 媒体账号冻结与解冻失败， 参数(冻结原因)为空. */
    E0200004("0200004", "媒体账号冻结与解冻失败， 参数(冻结原因)为空"),

    /** 数据库中已有30个活动，无法继续添加*/
    E0200005("0200005","列表最多添加30个活动"),

    /** 最多置顶三个活动，无法继续添加*/
    E0200006("0200006","列表最多置顶3个活动"),

    /** 权限不足*/
    E0200007("0200007","您没有此操作的权限"),

    /** 权限不足*/
    E0200008("0200008","您没该账号的权限"),
    // 媒体管理模块

    /** 创建媒体失败 */
    E0310010("0310010", "创建媒体失败"),

    /** 价格不能为空 */
    E0310011("0310011", "价格不能为空"),

    /** 分账比例不能为空 */
    E0310013("0310013", "分账比例不能为空"),

    /** 媒体分成比例和平台分成比例之和为100 */
    E0310014("0310014", "媒体分成比例与平台分成比例之和为100"),

    E0310015("0310015", "媒体不存在"),

    // 广告位模块
    /** 广告位ID不能为空 */
    E0401001("0401001", "广告位ID不能为空"),

    /** 该广告位不存在. */
    E0401002("0401002", "该广告位不存在"),

    /** 已经关联广告位，不能删除. */
    E0401003("0401003", "已经关联广告位，不能删除"),

    /** 屏蔽长度过长. */
    E0401004("0401004", "屏蔽长度过长"),

    E0401005("0401005", "还未开始比赛，不能设置结果"),

    E0401007("0401007", "广告位接入广告类型已经设置！"),

    E0401008("0401008", "当前广告位今日分成比例审核中，请联系审核人员审核完毕后处理！"),

    E0401009("0401009", "当前广告位今日分成比例已审核通过，请勿重复申请！"),

    /** 权重已存在. */
    E0401010("0401010", "权重已存在，无法添加"),
    E0401011("0401011", "参数为空"),
    E0401012("0401012", "该广告不是激励广告"),
    E0401013("0401013", "查不到广告"),
    E0401014("0401014", "查不到主弹层"),
    E0401015("0401015", "查不到金币弹层" ),
    E0401016("0401016", "主弹层类型有误"),
    E0401017("0401017", "金币弹层类型有误"),
    E0401018("0401018", "广告未通过审核或已失效"),
    E0401019("0401019", "广告已添加过"),
    E0401020("0401020", "对象为空"),
    E0401021("0401021", "sdk链接为空"),
    E0401022("0401022","置顶推荐活动已满，请移除部分活动"),



    E0401023("0401023", "子账号不能该更账户类型"),
    E0401024("0401024","该广告位接入类型为原生化活动，不能添加其他类型活动"),
    E0401025("0401025","该广告位接入类型不是原生化活动广告位，不能添加该类型活动"),


    E0401026("0401026", "任务版本格式错误"),
    // 数据模块,
    E0401027("0401028", "配置列表为空"),

    /** 商业化活动错误 */
    E0401028("0401028", "更新配置失败"),

    E0401029("0401029", "任务版本不能为空"),
    E0401030("0401030", "提现周期不能为空"),
    E0401031("0401031", "活动id不能为空"),
    E0401032("0401032","查不到动效id"),
    E0401033("0401033","保存失败"),

    E0402001("0402001", "查不到广告位流量策略"),
    E0402002("0402002", "配置重复，请重新选择"),
    E0402003("0402003", "定制配置无效，保存失败"),

    E0402004("0402004", "媒体ID不能为空"),
    E0402005("0402005", "所有媒体均已存在白名单"),



    // 数据模块

    E0402006("0402006", "插件已应用于SDK，无法删除！"),
    E0402007("0402007", "该sdk已在使用，无法删除"),
    E0402008("0402008", "配置有误，存在已定向媒体"),
    E0402009("0402009", "配置有误，该版本sdk已存在"),
    E0402010("0402010", "配置有误，该版本插件已存在"),
    E0402011("0402011", "配置有误，检查appId是否正确"),
    E0402012("0402012", "该插件不存在"),
    E0402013("0402013", "配置有误，该版本A/B测试记录已存在"),
    E0402014("0402014", "媒体ID有误"),
    E0402015("0402015", "SDK版本不可为空"),
    E0402016("0402016", "发布版本不可为空"),
    E0402017("0402017", "补丁版本不可为空"),
    E0402018("0402018", "热更新记录不存在"),
    E0402019("0402019", "广告位ID有误"),
    E0402020("0402020", "发布类型不可为空"),
    E0402021("0402021", "灰度发布,灰度人数不能为空"),
    E0402022("0402022", "该发布不是灰度发布"),
    E0402023("0402023", "审核通过的灰度才能发布到全量"),
    E0402024("0402024", "停止发布的补丁才能回滚"),
    E0402025("0402025", "审核通过的灰度才能停止发布"),
    E0402026("0402026", "热更新发布ID不能为空"),



    //原生相关
    E0403000("0403000", "所选媒体列表已有财务模型，请确认"),
    E0403001("0403001", "媒体id不可为空"),

    /** 导出数据失败 */
    E0502001("0502001", "导出数据失败"),
    /**广告位曝光PV不能小于广告位点击PV*/
    E0502002("0502002", "广告位曝光PV不能小于广告位点击PV"),
    /**广告位点击PV不能小于广告位点击UV*/
    E0502003("0502003", "广告位点击PV不能小于广告位点击UV"),

    // 财务管理模块
    /** 该月账单已经结算 */
    E0600000("0600000", "该月账单已经结算"),

    /** 结算后媒体分成不能大于广告收入 */
    E0600001("0600001", "结算后媒体分成不能大于广告收入"),

    /** 该月账单已经审核通过 */
    E0600002("0600002", "该月账单已经审核通过"),

    /**请重新登录*/
    E0600004("0600004", "请重新登录"),

    /**媒体结算进度-结算单*/
    E0600005("0600005", "存在结算单日期已录入"),

    /**月账单不存在*/
    E0600006("0600006", "月账单不存在"),

    // 活动管理模块
    E0700001("E0700001", "该活动存在活动推广计划，请勿删除"),

    /** 该活动已删除 */
    E0700002("0700002", "该活动已删除"),

    /** 该引导页已删除 */
    E0700003("0700003", "该引导页已删除"),

    /** 该活动已绑定引导页，请勿删除 */
    E0700004("E0700004", "该活动已绑定引导页，请勿删除"),

    /** 该引导页皮肤正在使用，请勿删除 */
    E0700005("E0700005", "该引导页皮肤正在使用，请勿删除"),

    /** 该浮标不存在 */
    E0700006("E0700006", "该浮标不存在"),

    /** 浮标显示频次值不正确 */
    E0700007("E0700007", "浮标设置次数不能大于活动参与次数"),

    /** 该奖品正在活动中投放,请勿删除 */
    E0700008("E0700008", "该奖品正在活动中投放,请勿删除."),

    E0700009("E0700009", "该插件不存在或已关闭."),

    E0700010("E0700010", "该皮肤已经被插件使用，请勿删除."),

    E0700011("E0700011", "该浮标活动正在使用，请勿删除或关闭."),

    E0700012("E0700012", "该活动已结束."),

    E0700013("E0700013", "该插件已关闭."),

    E0700014("E0700014", "插件列表存在相同插件."),

    E0700015("E0700015", "该插件不为嵌入式插件."),

    E0700016("E0700016", "该插件已删除."),

    E0700017("E0700017", "以下广告不可用"),

    E0700018("E0700018","请至少配置一个浮标"),

    E0700019("E0700019","不能添加多个重复的浮标"),

    E0700020("E0700020","不能添加已关闭、删除的浮标"),

    E0700021("E0700021","请至少配置一个主会场、直投页或活动ID"),

    E0700121("E0700101","请至少配置一个插件"),

    E0700022("E0700022","请输入有效的主会场ID"),

    E0700023("E0700023","请输入正确的主会场页面占比"),

    E0700024("E0700024","不能添加多个重复的活动ID"),

    E0700025("E0700025","最多配置5个浮标"),

    E0700026("E0700026","浮标ID为空"),

    E0700027("E0700027","广告弹层不存在"),

    E0700028("E0700028","弹层id不能相同"),

    E0700029("0700029", "与复制的广告位ID重复"),

    E0700030("0700030", "广告位下面的没有复制的活动"),

    E0700031("E0700031","广告id为空"),

    E0700032("E0700032", "落地页URL概率配置不正确."),

    E0700033("E0700033", "请至少配置1个落地页URL"),

    E0700034("E0700034", "请至少配置1个URL中的配置浮标"),

    E0700035("E0700035","直接页活动区块为空"),

    E0700036("E0700036","请填主会场区块为空"),

    E0700037("E0700037","请输入有效的活动Id"),

    E0700038("E0700038","请输入有效主会场Id"),

    E0700039("E0700039","导入失败，一次最多可到导入25W份券码"),

    E0700040("E0700040","导入失败，劵码包含中文"),

    E0700041("E0700041","劵码不能为空"),

    E0700042("E0700042","劵码导入失败"),

    E0700043("E0700043","奖品不存在"),

    E0700044("E0700044","导入失败，密码包含中文"),

    E0700045("E0700045","请使用示例下载的文件格式"),

    E0700046("E0700046","excel 版本问题"),

    E0700047("E0700047","QB定额输入的数量有误"),
    E0700048("E0700048","QB随机输入的数量有误"),
    E0700049("E0700049","Q币的PrizeId为null"),
    E0700050("E0700050","不能添加多个重复的推广计划ID"),
    E0700051("E0700051","不能添加多个重复host"),
    E0700052("E0700052","仅支持嵌入式插件"),
    E0700053("E0700053","请输入有效的插件ID"),
    E0700054("E0700054","直投页嵌入式插件区块为空"),
    E0700055("E0700055","请输入有效游戏Id"),
    E0700056("E0700056","请输入有效直投页Id"),
    E0700057("E0700057","该瓜分红包直投页已被配置"),


    E0700058("E0700058","请输入正确的页面占比"),
    E0700059("E0700058","请输入正确的活动页面占比"),
    E0700060("E0700060","广告最多可选择10条"),
    E0700061("E0700061","弹层ID不能重复"),
    E0700062("E0700062","请输入正确的直投页页面占比"),
    E0700063("E0700063","参数为空"),

    E0700065("E0700065","奖品描述已存在，请重新输入"),

    E0700066("E0700066","导入失败"),

    E0700067("E0700067","该行参数有误"),

    E0700068("E0700068","该活动已经被视频互动广告绑定"),

    //订单模块
    E0800001("E0800001","订单不存在"),

    //区块名称为空
    E0900001("E0900001","区块名称为空"),

    E0900002("E0900002", "区块或者区域重复"),

    E0900003("E0900003", "零钱奖励参数填写有误"),

    E0900004("E0900004", "每日预算金额有误，请填写：[0~99999.99]"),

    E0900005("E0900005", "奖励金额有误，请填写：(0~每日预算金额]"),

    E0900006("E0900006", "每日参与次数有误，请填写：[1~10]"),

    E0900007("E0900007", "中奖概率有误，请填写：[0~100]"),

    E0900008("E0900008", "中奖最小金额不能大于最大金额"),

	E0900100("E0900100", "通知风控最终分成比例失败"),

    //域名管理
    E1000001("1000001", "告警人重复"),
    E1000002("1000002", "域名重复"),
    E1000003("1000003", "域名不能为空"),
    E1000004("1000004", "不支持批量更新"),
    E1000005("1000005", "新增域名成功，重复域名："),
    E1000006("1000006", "二级标签不存在"),
    E1000007("1000007", "尚无SSO账户有域名管理权限"),
    E1000008("1000008", "域名策略流量分级标签重复"),
    E1000009("1000009", "域名填写有误"),
    E10000011("10000011", "微信流量不可开启媒体域名审核，请关闭"),
    E10000012("10000012", "向中台查询域名出错，请重试"),
    E10000013("10000013", "中台无此域名，请先添加"),
    E10000014("10000014", "当前域名在域名切换中使用，请先在域名切换中删除"),
    E10000015("10000015", "当前不存在"),
    E10000016("10000016", "删除中台域名失败，请重试"),
    E10000017("10000017", "中台域名处理失败"),

    //预付款
    E1000010("1000010", "账号Id不存在"),
    E1000040("1000040", "预付款单号不能为空"),
    E1000041("1000041", "无该预付款订单"),
    E1000042("1000042", "该预付款订单还未打款"),
    E1000043("1000043", "该媒体当前还是预付款媒体，请先更改类型"),

    //素材库批量上传素材
    E1000011("1000011", "上传的必须是jpg,jpeg,png,gif类型的图片或mp4格式的视频"),
    E1000012("1000012", "广告位尺寸不存在"),
    E1000013("1000013", "大小必须控制在1MB以内"),
    E1000014("1000014", "此素材已经被上传过"),
    E1000015("1000015", "素材数据为空"),
    E1000027("1000027", "该广告位不支持动图"),
    E1000028("1000028", "请至少配置5张素材"),
    E1000029("1000029", "该广告位计费类型为CPC，不支持素材算法推荐"),

    E1000030("1000030", "时长不超过30s"),
    E1000031("1000031", "大小必须控制在5M以内"),
    E1000032("1000032", "无法获取视频宽高"),
    E1000033("1000033", "读取视频文件失败"),

    E1000034("1000034", "广告位的可用素材不足5张，禁止添加"),

    E1000035("1000035", "广告位算法挑选素材不足5张，禁止添加"),
    E1000036("1000036", "媒体挑选可用素材不足5张，禁止添加"),
    E1000037("1000037", "广告位不支持该素材格式，禁止添加"),
    E1000038("1000038", "上传的adx素材不符合尺寸标准"),
    E1000039("1000039", "上传的adx素材%s不符合尺寸标准"),


    /** 广告位浮标配置 */
    E1000016("1000016", "广告位id不能为空!"),
    E1000017("1000017", "广告位id不存在!"),
    E1000018("1000018", "含有非风控标签！"),
    E1000026("E1000026", "含有非用户画像标签！"),

    /** UV分流校验 */
    E1000019("1000019", "UV分流比例不能为0"),
    E1000020("1000020", "UV分流推广计划列表不能为空"),
    E1000021("1000021", "UV分流推广计划ID重复"),
    E1000022("1000022", "UV分流比例必须能被推广计划列表个数整除"),
    E1000023("1000023", "推广计划ID:$无效"),
    E1000024("1000024", "推广计划ID:$未定向到该媒体"),
    E1000025("1000025", "推广计划ID:$推广计划状态为关闭"),

    E1100001("1100001", "上上签服务调用结果异常"),

    /** adx相关 */
    E1200001("1100001", "adx变更资源位投放方式请求参数异常"),
    E1200002("1100002", "adx变更资源位投放方式投放比例异常"),
    E1300003("1300003", "该推广组不存在"),
    E1300004("1300004", "资源位未绑定广告位"),
    E1300005("1300005", "资源位绑定广告位尺寸大小不一致"),
    E1300006("1300006", "资源位绑定的广告位不存在"),
    E1300007("1300007", "资源位不存在"),
    E1300008("1300008", "资源位广告位修改前后尺寸不一致"),
    E1300009("1300009", "该资源位不支持动态查询广告样式"),
    E1300010("1300010", "该Adx下已存在相同名称的广告位类型"),
    E1300011("1300011", "该广告位类型不允许编辑"),
    E1300012("1300012", "该广告位类型不存在"),
    E1300013("1300013", "此广告位类型正在被使用，无法删除"),
    E1300014("1300014", "该Adx广告位Id不存在"),
    E1300015("1300015", "该广告位样式不存在"),
    E1300016("1300016", "此广告位样式正在被使用，无法删除"),
    E1300017("1300017", "该Adx下已存在相同的广告位样式ID"),
    E1300018("1300018", "该Adx的广告位类型下已存在相同名称的样式名称"),
    E1300019("1300019", "此素材格式不支持"),
    E1300020("1300020", "请输入0-9999之间的数字"),
    E1300021("1300021", "该Adx下已存在相同的广告位类型ID"),
    E1300022("1300022", "此广告位类型正被使用，无法编辑"),
    E1300023("1300023", "此广告位样式正被使用，无法编辑"),
    E1300024("1300024", "素材数量必须在大于0个，小于10个"),
    E1300025("1300025", "样式名称长度不能超过50"),
    E1300026("1300026", "创意内容标题长度不符合"),
    E1300027("1300027", "创意内容描述长度不符合"),
    E1300028("1300028", "请输入0-1023之间的数字"),
    E1300029("1300029", "标题字数输入有误"),
    E1300030("1300030", "描述字数输入有误"),
    E1300031("1300031", "此广告位类型下的广告位样式正被使用，无法编辑"),
    E1300032("1300032", "此广告位类型下的广告位样式正被使用，无法删除"),
    E1300033("1300033", "广告位类型ID不能为空"),
    E1300034("1300034", "视频编码格式不支持"),
    E1300035("1300035", "该Adx的广告位类型下已存在相同的Adx广告位ID"),
    E1300036("1300036", "请输入标题字数"),
    E1300037("1300037", "请输入描述字数"),
    E1300038("1300038", "推广组id不能为空"),
    E1300039("1300039", "创意id不能为空"),
    E1300040("1300040", "样式视频时长范围错误"),
    E1300041("1300041", "资源位保存人群信息参数错误"),
    E1300042("1300042", "id不能超过100个"),
    E1300043("1300043", "创意素材ID无效"),
    E1300044("1300044", "上传素材ID无效"),
    E1300045("1300045", "资源位id不能为空"),



    /** CRM同步 **/
    E1400000("1300000","参数不完整"),
    E1400001("1300001","该媒体账户信息已存在CRM中"),
    E1400002("1400002","更新媒体账户媒介信息异常"),

    /** 大盘切流量测试 **/
    E1500011("1500001","测试的开关关闭,无法添加活动运营"),
    E1500012("1500002","添加活动运营比例不能超过设置的活动运营测试比例"),

    /** 深度互动 **/
    E1600001("1600001","新增任务配置异常"),
    E1600002("1600002","更新任务配置异常"),

    /**皮肤弹层配置**/
    E0700064("E0700064","弹层占比之和需要为100%"),
    /**皮肤弹层配置**/
    E1700013("E1700013","UV分流活动百分比相加之和不为100"),



    /** 配置产品化 **/
    E1700001("1700001","该配置已存在"),
    /**
     * tuia-domain-manager 域名管理系统
     */
    E1800000("1800000","平台字段->platForm为空或者不合法"),
    E1800002("1800002","使用场景字段->domainScene为空或者不合法"),
    E1800005("1800005","域名来源字段->domainSource为空或者不合法"),
    E1800006("1800006","证书类型字段->httpType为空或者不合法"),
    E1800007("1800007","是否可申请字段->canApply为空或者不合法"),
    E1800008("1800008","域名类型字段->domainType为空或者不合法"),
    E1800009("1800009","业务类型字段->businessType为空或者不合法"),
    E1800010("1800010","业务空间字段->businessSpace为空或者不合法"),
    E1800011("1800011","获取不到操作人"),

    E1810000("1810000","域名字段->domainName为空"),
    E1810001("1810001","域名所属人id字段->adminId为空"),
    E1810002("1810002","域名所属人字段->adminName为空"),
    E1810003("1810003","ipc备案号字段->icpNumber为空"),
    E1810004("1810004","备案主体字段->icpNumberBody为空"),
    E1810005("1810005","域名流量分级标签字段->tagIds为空"),
    E1810006("1810006","部门id字段->deptId为空"),
    E1810007("1810007","可用行业字段->newTrade为空"),
    E1810008("1810008","应用范围字段->strategyId为空"),

    E1820000("1820000","未知的消息TAG"),
    E1820001("1820001","更新域名表状态异常"),
    E1820002("1820002","新增域名使用记录记录异常"),
    E1820003("1820003","申请时，没有满足要求的域名"),
    E1820004("1820004","申请时，域名存在问题，请重试一次"),


    E1900004("E1900004","分流配比总和不能超过100%"),

    E1900005("E1900005","所有活动组流量相加之和为100%"),

    /** 算法切量 **/
    E1900003("E1900003","PV分流修改比例不合理，填值已超"),

    /** 素材定时投放配置 **/
    E1900001("E1900001", "投放开始时间不能大于结束时间"),
    //活动模块

    /** 该活动不可用. */
    E2000001("E2000001", "该活动不可用"),
    E2000002("E2000002", "该活动已存在"),
    E2000003("E2000003", "该推广计划已开启了分流投放"),

    /** 媒体用户画像子标签名称不能重复 */
    E2000004("E2000004", "媒体用户画像子标签名称不能重复"),

    /** 测试广告计划选择的广告位周期不能重复 */
    E2100001("E2100001", "测试流量重复使用请重新选择流量"),

    /** QA提问 */
    E2200000("2200000", "反馈内容不能为空"),
    E2200001("2200001", "回复内容不能少于8个符"),
    E2200002("2200002", "图片数量超出限制"),

    /**
     * 活动标题
     */
    E2300001("E2300001", "标题内容不能重复"),

    /**
     *  已存在广告位测试计划
     */
    E0400002("E0400002", "广告位已存在测试计划,slotId:"),

    E0400003("E0400003","已存在大盘测试计划"),

    E0400004("E0400004", "测试组不存在"),

    E0400005("E0400005", "测试组总比例不等于100"),

    E0400006("E0400006", "测试比例不能小于0"),


    E0500000("E0500000", "请至少选择一条广告主数据"),

    E0500001("E0500001", "adx类型不存在"),

    E0500002("E0500002", "adx类型无广告主送审"),

    /**
     * 任务中心
     */
    E2400001("2400001","保存任务中心活动配置异常"),
    E2400002("2400002","重置广告位次数失败"),
    E2400003("2400003","保存广告位维度投放任务中心活动配置异常"),
    E2400004("2400004","保存广告位创新业务特殊配置异常"),

    /**
     * SDK
     */
    E2500001("2500001","补丁不存在"),
    E2500004("2500004","补丁已使用"),
    E2500005("2500005","SDK热更新发布失败"),


    E2600001("2600001", "生效值不能为空，对象只能包含数字，英文逗号"),
    E2600002("2600002", "列表对应的值非json数组格式"),
    E2600003("2600003", "json中的id存在重复现象"),
    E2600004("2600004", "当前资源id对应的信息不存在："),
    E2600005("2600005", "创意素材ID无效"),

    /**
     * 广告位/素材尺寸相关
     */
    E2700001("2700001","该尺寸已存在"),

    E2700002("2700002","无目标广告位，请确认"),

    /**
     * 爱奇艺静态页面送审相关
     */
    E2800001("2800001","不存在该送审记录"),


    E0901031("0901031", "域名已存在！"),

    E0901032("0901032", "素材添加失败！"),
    E0901033("0901033", "结算主体未签署合同！"),

    ;


    /** 错误码. */
    private String code;

    /** 中文描述. */
    private String desc;

    /**
     * The Constructor.
     *
     * @param code the error code
     * @param desc the desc
     */
    private ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }




    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

}
