package cn.com.duiba.tuia.domain.manager.api.constant.exception;

import cn.com.duiba.tuia.domain.manager.api.constant.enums.ErrorCode;
import org.apache.commons.lang3.builder.ToStringBuilder;
/**
 * @description     <p>域名平台异常类定义
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
public class DomainException extends RuntimeException{
    /** The result code. */
    private final String      resultCode;

    /** The result message. */
    private final String      resultMessage;

    /**
     * The Constructor.
     *
     * @param code the code
     */
    public DomainException(ErrorCode code) {
        super();
        this.resultCode = code.getCode();
        this.resultMessage = code.getDesc();
    }

    /**
     * The Constructor.
     *
     * @param code the code
     * @param cause the cause
     */
    public DomainException(ErrorCode code, Throwable cause) {
        super(cause);
        this.resultCode = code.getCode();
        this.resultMessage = code.getDesc();
    }

    /**
     * The Constructor.
     *
     * @param code
     * @param desc
     */
    public DomainException(String code, String desc) {
        super();
        this.resultCode = code;
        this.resultMessage = desc;
    }

    /**
     * Gets the result code.
     *
     * @return the resultCode
     */
    public String getResultCode() {
        return resultCode;
    }

    /**
     * Gets the result message.
     *
     * @return the resultMessage
     */
    public String getResultMessage() {
        return resultMessage;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
