/**
 * 
 */
package cn.com.duiba.tuia.domain.manager.api.model;


import lombok.Data;

import java.io.Serializable;

/**
 * @description  <p>此类描述的是： 分页查询条件.
 * @author cuiwx
 * @version 1.0 2022/2/28
 */
@Data
public class ReqPageQuery implements Serializable {

    /**序列号*/
    private static final long serialVersionUID = -3434405636455884638L;

    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_70    = 70;


    /** 每页20条记录. */
    public static final int PAGE_SIZE_100    = 100;

    /** 最大导出一万条. */
    public static final int MAX_EXPORT_SIZE = 10000;

    /** 分页导出最大导出50万条. */
    public static final int MAX_PAGE_EXPORT_SIZE = 500000;

    /** 起始记录数. */
    private Integer         rowStart        = 0;

    /** 当前页. */
    private Integer         currentPage     = 1;

    /** 每页记录数. */
    private Integer         pageSize;

    /** 排序字段(默认排序字段为：gmt_modified). */
    private String          sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String          order           = "desc";
    
    /** 拼接字段查询使用*/
    private String          conditionStr;
}
