package cn.com.duiba.tuia.domain.manager.api.model.internal;

import cn.com.duiba.tuia.domain.manager.api.constant.ConstantBiz;
import cn.com.duiba.tuia.domain.manager.api.constant.exception.DomainException;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ErrorCode;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.*;
import cn.com.duiba.tuia.domain.manager.api.model.req.DomainAddReq;
import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.util.Objects;

/**
 * @description     <p>数据同步基础数据
 * @author cuiwx
 * @version 1.0 2022/2/28
 */
@Data
public class DomainSynDataBaseBean {
    /**
     * 业务来源
     * {@link ENDomainSynDataSource}
     */
    private Integer source;
    /**
     * 平台
     * {@link ENPlatForm}
     */
    private Integer platForm;
    /**
     * 操作
     * {@link ENDomainSynDataState}
     */
    private Integer operator;
    /**
     * 新增时候/申请时候：域名表tb_domain_manager，域名id
     * 下线时候/删除时候：域名使用记录表tb_domain_use_record，id
     */
    private Long domainId;
    /**
     * 域名表tb_domain_manager，域名
     */
    private String domainName;
    /**
     * 域名场景
     */
    private Integer domainScene;
    /**
     * 域名申请人id
     */
    private Long adminId;
    /**
     * 域名申请人
     */
    private String adminName;

    public void checkSpecialField(DomainAddReq domainAddReq) {
        // 校验业务类型
        if(Objects.isNull(ENPlatForm.getEnumByValue(domainAddReq.getBusinessType()))){
            throw new DomainException(ErrorCode.E1800009);
        }
        // 校验业务空间
        if(Objects.isNull(ENBusinessSpace.getEnumByValue(domainAddReq.getBusinessSpace()))){
            throw new DomainException(ErrorCode.E1800010);
        }
        // 校验platForm合法性
        if (Objects.isNull(ENPlatForm.getEnumByValue(domainAddReq.getPlatForm()))) {
            throw new DomainException(ErrorCode.E1800000);
        }
        // 校验domainName
        if(StrUtil.isBlank(domainAddReq.getDomainName())){
            throw new DomainException(ErrorCode.E1810000);
        }
        // 校验domainScene
        if(Objects.isNull(domainAddReq.getDomainSource())){
            throw new DomainException(ErrorCode.E1800002);
        }
        // 校验adminId
        if(Objects.isNull(domainAddReq.getAdminId())){
            throw new DomainException(ErrorCode.E1810001);
        }
        // 校验adminName
        if(StrUtil.isBlank(domainAddReq.getAdminName())){
            throw new DomainException(ErrorCode.E1810002);
        }
        // 域名来源
        if(Objects.isNull(ENDomainSource.getEnumByValue(domainAddReq.getDomainSource()))){
            throw new DomainException(ErrorCode.E1800005);
        }
        // 新增是否可申请
        if(Objects.isNull(ENYesOrNo.getEnumByValue(domainAddReq.getCanApply()))){
            throw new DomainException(ErrorCode.E1800007);
        }
    }

    public String getMsgTag() {
        return ConstantBiz.TAG_PREFIX + this.source + StrUtil.UNDERLINE + this.platForm;
    }
}
