package cn.com.duiba.tuia.domain.manager.api.model.internal;

import lombok.Data;

/**
 * @description     <p>同步数据响应对象
 * 业务{三方系统响应同步结果},平台{0},域名id{1},域名{},操作{2},使用场景{},申请人{},同步数据结果{3},原因{原因}
 * @author cuiwx
 * @version 1.0 2022/2/28
 */
@Data
public class DomainSynDataResp extends DomainSynDataBaseBean {
    /**
     * 数据同步异常时的钉钉消息内容
     * success = false 时，即同步失败需要填写该字段
     */
    private String synExceptionMsg;
    /**
     * 成功标识，以下情况可以返回true
     * 1.新增时候，三方系统成功新增一条数据
     * 2.新增时候，三方系统已经存在对应域名数据，并更新对应域名数据成功，建议返回true（此情况为异常情况，需要三方系统根据业务情况返回对应的成功或失败；如若返回失败，则需要填写synExceptionMsg，描述具体的失败原因）
     * 3.删除时候，三方系统成功删除一条数据
     * 4.删除时候，三方系统不存在对应域名数据，或者对应域名数据已经是删除状态，建议返回true（此情况为异常情况，需要三方系统根据业务情况返回对应的成功或失败；如若返回失败，则需要填写synExceptionMsg，描述具体的失败原因）
     */
    private Boolean success;
}
