package cn.com.duiba.tuia.domain.manager.api.model.internal;

import cn.com.duiba.tuia.domain.manager.api.constant.exception.DomainException;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ErrorCode;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDomainType;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENHttpType;
import cn.com.duiba.tuia.domain.manager.api.model.req.DomainAddReq;
import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.util.Objects;

/**
 * @description     <p>同步数据至媒体管理后台-域名管理
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
@Data
public class SynDataSspDomainReq extends DomainSynDataBaseBean {
    /**
     * 域名
     */
    /**
     * icp备案号
     */
    private String icpNumber;
    /**
     * 备案主体
     */
    private String icpNumberBody;
    /**
     * 是否有证书
     * {@link ENHttpType}
     */
    private Integer httpType;
    /**
     * 域名类型
     * {@link ENDomainType}
     */
    private Integer domainType;
    /**
     * 域名流量分级标签
     * eg:44-90-360,44-90-361
     */
    private String tagIds;

    @Override
    public void checkSpecialField(DomainAddReq domainAddReq) {
        // 校验platForm合法性
        // 校验domainName
        // 校验domainScene
        // 校验adminId
        // 校验adminName
        // 域名来源
        // 新增是否可申请
        super.checkSpecialField(domainAddReq);

        // ipc备案号
        if(StrUtil.isBlank(domainAddReq.getIcpNumber())){
            throw new DomainException(ErrorCode.E1810003);
        }
        // 备案主体
        if(StrUtil.isBlank(domainAddReq.getIcpNumberBody())){
            throw new DomainException(ErrorCode.E1810004);
        }
        // 是否有证书
        if(Objects.isNull(ENHttpType.getEnumByValue(domainAddReq.getHttpType()))){
            throw new DomainException(ErrorCode.E1800006);
        }
        // 域名类型
        if(Objects.isNull(ENDomainType.getEnumByValue(domainAddReq.getDomainType()))){
            throw new DomainException(ErrorCode.E1800008);
        }
        // 域名流量分级标签
        if(StrUtil.isBlank(domainAddReq.getTagIds())){
            throw new DomainException(ErrorCode.E1810000);
        }
    }
}
