package cn.com.duiba.tuia.domain.manager.api.model.internal;

import cn.com.duiba.tuia.domain.manager.api.constant.exception.DomainException;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ErrorCode;
import cn.com.duiba.tuia.domain.manager.api.model.req.DomainAddReq;
import cn.hutool.core.util.StrUtil;
import lombok.Data;

/**
 * @description     <p>同步数据至媒体管理后台-小程序代理域名
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
@Data
public class SynDataSspWeChatDomainProxyReq extends DomainSynDataBaseBean {
    /**
     * 域名
     */
    /**
     * icp备案号
     */
    private String icpNumber;

    @Override
    public void checkSpecialField(DomainAddReq domainAddReq) {
        // 校验platForm合法性
        // 校验domainName
        // 校验domainScene
        // 校验adminId
        // 校验adminName
        // 域名来源
        // 新增是否可申请
        super.checkSpecialField(domainAddReq);

        // ipc备案号
        if(StrUtil.isBlank(domainAddReq.getIcpNumber())){
            throw new DomainException(ErrorCode.E1810003);
        }
    }
}
