package cn.com.duiba.tuia.domain.manager.api.model.internal;

import cn.com.duiba.tuia.domain.manager.api.constant.exception.DomainException;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ErrorCode;
import cn.com.duiba.tuia.domain.manager.api.model.req.DomainAddReq;
import lombok.Data;

import java.util.Objects;

/**
 * @description     <p>同步数据至星盟台-短链拦截入口
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
@Data
public class SynDataUsShortUrlBreakReq extends DomainSynDataBaseBean {
    /**
     * 域名
     */
    /**
     * 星盟台-域名所属部门
     */
    private Long deptId;

    @Override
    public void checkSpecialField(DomainAddReq domainAddReq) {
        // 校验platForm合法性
        // 校验domainName
        // 校验domainScene
        // 校验adminId
        // 校验adminName
        // 域名来源
        // 新增是否可申请
        super.checkSpecialField(domainAddReq);

        // 部门id
        if(Objects.isNull(domainAddReq.getDeptId())){
            throw new DomainException(ErrorCode.E1810006);
        }
    }
}
