package cn.com.duiba.tuia.domain.manager.api.model.internal;

import cn.com.duiba.tuia.domain.manager.api.constant.exception.DomainException;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ErrorCode;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENHttpType;
import cn.com.duiba.tuia.domain.manager.api.model.req.DomainAddReq;
import lombok.Data;

import java.util.Objects;

/**
 * @description     <p>不需要同步数据至任何平台，仅本系统添加
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
@Data
public class SynDataWithOutReq extends DomainSynDataBaseBean {

    @Override
    public void checkSpecialField(DomainAddReq domainAddReq) {
        // 校验platForm合法性
        // 校验domainName
        // 校验domainScene
        // 校验adminId
        // 校验adminName
        // 域名来源
        super.checkSpecialField(domainAddReq);

        // 是否有证书
        if(Objects.isNull(ENHttpType.getEnumByValue(domainAddReq.getHttpType()))){
            throw new DomainException(ErrorCode.E1800006);
        }
    }
}
