package cn.com.duiba.tuia.domain.manager.api.model.internal;

import cn.com.duiba.tuia.domain.manager.api.constant.exception.DomainException;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ErrorCode;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDomainType;
import cn.com.duiba.tuia.domain.manager.api.model.req.DomainAddReq;
import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.util.Objects;

/**
 * @description     <p>同步数据至钟馗
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
@Data
public class SynDataZhongKuiDomainReq extends DomainSynDataBaseBean {
    /**
     * 域名
     */
    /**
     * 域名类型
     * {@link ENDomainType}
     */
    private Integer domainType;
    /**
     * 钟馗-可用行业
     */
    private String newTrade;
    /**
     * 钟馗-应用范围
     */
    private Long strategyId;

    @Override
    public void checkSpecialField(DomainAddReq domainAddReq) {
        // 校验platForm合法性
        // 校验domainName
        // 校验domainScene
        // 校验adminId
        // 校验adminName
        // 域名来源
        // 新增是否可申请
        super.checkSpecialField(domainAddReq);

        // 域名类型
        if(Objects.isNull(ENDomainType.getEnumByValue(domainAddReq.getDomainType()))){
            throw new DomainException(ErrorCode.E1800008);
        }
        // 可用行业
        if(StrUtil.isBlank(domainAddReq.getNewTrade())){
            throw new DomainException(ErrorCode.E1810007);
        }
        // 应用范围
        if(Objects.isNull(domainAddReq.getStrategyId())){
            throw new DomainException(ErrorCode.E1810008);
        }
    }
}
