package cn.com.duiba.tuia.domain.manager.api.model.req;

import cn.com.duiba.tuia.domain.manager.api.constant.enums.*;
import lombok.Data;

import java.io.Serializable;
/**
 * @description <p>域名管理界面添加域名参数
 * @author cuiwx
 * @version 1.0 2022/2/25
 */
@Data
public class DomainAddReq implements Serializable {
    /**
     * 业务类型
     * {@link ENDomainSynDataSource}
     */
    private Integer businessType;
    /**
     * 业务空间
     * {@link ENBusinessSpace}
     */
    private Integer businessSpace;
    /**
     * 域名
     */
    private String domainName;
    /**
     * 域名来源
     * {@link ENDomainSource}
     */
    private Integer domainSource;
    /**
     * 是否有证书
     * {@link ENHttpType}
     */
    private Integer httpType;
    /**
     * 平台
     * {@link ENPlatForm}
     */
    private Integer platForm;
    /**
     * icp备案号
     */
    private String icpNumber;
    /**
     * 备案主体
     */
    private String icpNumberBody;
    /**
     * 域名类型
     * {@link ENDomainType}
     */
    private Integer domainType;
    /**
     * 域名流量分级标签
     * eg:44-90-360,44-90-361
     */
    private String tagIds;
    /**
     * 钟馗-可用行业
     */
    private String newTrade;
    /**
     * 钟馗-应用范围
     */
    private Long strategyId;
    /**
     * 域名是否可被申请
     * {@link ENYesOrNo}
     */
    private Integer canApply;
    /**
     * 星盟台-域名所属部门
     */
    private Long deptId;
    /**
     * 用户线程中取：用户id
     */
    private Long adminId;
    /**
     * 用户线程中取：用户name
     */
    private String adminName;
}
