package cn.com.duiba.tuia.domain.manager.api.model.req;

import cn.com.duiba.tuia.domain.manager.api.constant.enums.*;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
/**
 * @description     <p>域名管理界面申请域名参数
 * @author cuiwx
 * @version 1.0 2022/3/4
 */
@Data
@Accessors(chain = true)
public class DomainApplyReq implements Serializable {
    /**
     * 业务空间
     * {@link ENBusinessSpace}
     */
    private Integer businessSpace;
    /**
     * 平台
     * {@link ENPlatForm}
     */
    private Integer platForm;
    /**
     * 使用场景
     * {@link ENDomainScene}
     */
    private Integer domainScene;
    /**
     * 域名来源
     * {@link ENDomainSource}
     */
    private Integer domainSource;
    /**
     * 是否有证书
     * {@link ENHttpType}
     */
    private Integer httpType;
    /**
     * 微信点击状态
     * 0:正常
     * 1:异常
     */
    private Integer weChatStatus;
    /**
     * 微信扫码状态
     * 0:正常
     * 1:异常
     */
    private Integer weChatScanStatus;
    /**
     * 手机QQ状态
     * 0:正常
     * 1:异常
     */
    private Integer qqStatus;
    /**
     * 支付宝状态
     * 0:正常
     * 1:异常
     */
    private Integer alipayStatus;
    /**
     * CDN状态
     * 0:初始化
     * 1:正常
     * 2:异常
     */
    private Integer domainCdnStatus;
}
