package cn.com.duiba.tuia.domain.manager.api.model.req;

import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDomainScene;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENPlatForm;
import lombok.Data;

import java.io.Serializable;

/**
 * @description     <p>域名常量字典查询请求参数
 * @author cuiwx
 * @version 1.0 2022/3/2
 */
@Data
public class DomainDictionaryReq implements Serializable {
    /**
     * 字典key
     */
    private String dictionary;
    /**
     * 空间,ENDomainScene枚举定制，需要根据space过滤
     * {@link ENDomainScene}
     */
    private String space;
    /**
     * 平台,ENPlatForm 枚举定制，需要根据platForm过滤
     * {@link ENPlatForm}
     */
    private Integer platForm;

}
