package cn.com.duiba.tuia.domain.manager.api.model.req;

import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENBusinessSpace;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDeleted;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDomainSource;
import cn.com.duiba.tuia.domain.manager.api.model.ReqPageQuery;
import lombok.Data;

/**
 * @description     <p>域名管理界面查询参数
 * @author cuiwx
 * @version 1.0 2022/2/24
 */
@Data
public class DomainQueryReq extends ReqPageQuery {
    /**
     * 业务空间
     * {@link ENBusinessSpace}
     */
    private Integer businessSpace;
    /**
     * 域名
     */
    private String domainName;
    /**
     * 域名来源
     * {@link ENDomainSource}
     */
    private Integer domainSource;
    /**
     * 创建人id
     */
    private Long adminId;
    /**
     * 状态
     * {@link ENDeleted}
     */
    private Integer deleted;
}
