package cn.com.duiba.tuia.domain.manager.api.model.req;

import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENAuditStatus;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDomainSynState;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @description <p>域名管理界面域名使用记录参数
 * @author cuiwx
 * @version 1.0 2022/2/25
 */
@Data
@Accessors(chain = true)
public class DomainUseRecordReq implements Serializable {
    /**
     * 域名表id
     */
    private Long domainId;
    /**
     * 审核记录
     * {@link ENAuditStatus}
     */
    private List<Integer> auditStatusList;
    /**
     * 同步状态
     * {@link ENDomainSynState}
     */
    private List<Integer> synStateList;
}
