package cn.com.duiba.tuia.domain.manager.api.model.resp;

import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDeleted;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENDomainSource;
import cn.com.duiba.tuia.domain.manager.api.constant.enums.ENHttpType;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * @description <p>域名管理界面查询返回对象
 * @author cuiwx
 * @version 1.0 2022/2/24
 */
@Data
public class DomainQueryResp implements Serializable {
    /**
     * id
     */
    private Long id;
    /**
     * 域名
     */
    private String domainName;
    /**
     * 域名来源
     * {@link ENDomainSource}
     */
    private Integer domainSource;
    /**
     * 翻译字段：域名来源
     */
    private String domainSourceStr;
    /**
     * 是否有证书
     * {@link ENHttpType}
     */
    private Integer httpType;
    /**
     * 翻译字段：是否有证书
     */
    private String httpTypeStr;
    /**
     * 域名使用情况
     */
    private String domainSceneStr;
    /**
     * 创建人id
     */
    private Long adminId;
    /**
     * 创建人名称
     */
    private String adminName;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 翻译字段：创建时间
     */
    private String gmtCreateStr;
    /**
     * 状态
     * {@link ENDeleted}
     */
    private Integer deleted;
    /**
     * 翻译字段：状态
     */
    private String deletedStr;
}
