package cn.com.duiba.tuia.domain.manager.api.result;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @description  <p> 返回类定义
 * @author cuiwx
 * @version 1.0 2022/2/28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ResultPage<T> {
    /**
     * 当前页面
     */
    private Integer currentPage;
    /**
     * 总页数
     */
    private Integer totalPage;
    /**
     * 分页查询count总数.
     */
    private Long totalCount;
    /**
     * 分页查询结果集.
     */
    private List<T> list;

    public ResultPage(Long totalCount, List<T> list) {
        this.totalCount = totalCount;
        this.list = list;
    }
}
