package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.UserDto;

/**
 * 用户详情的service
 * @author lichao 2019/4/3
 */
@AdvancedFeignClient
public interface RemoteUserService {

    /**
     * 用户登录注册
     * @param appId 媒体id
     * @param deviceId 设备id
     * @param muId 第三方账户id
     * @return
     */
    UserDto getOrCreateUser(Long appId,String deviceId,String muId);

    /**
     * 通过用户id查询用户
     * @param userId
     * @return
     */
    UserDto findUser(Long userId);
}
