package cn.com.duiba.tuia.ecb.center.enums;

/**
 * Created by xuefeng on 2019/8/13.
 */
public enum VideoAlg {

    RANDOM(0, "随机规则"),
    DOWNLOAD(1, "下载优先规则"),
    NEWV(2, "新素材"),
    PRICE(3, "价格优先规则"),
    MANUAL(4, "人工规则"),
    ;

    private Integer alg;
    private String name;

    VideoAlg(Integer alg, String name) {
        this.alg = alg;
        this.name = name;
    }

    public Integer getAlg() {
        return this.alg;
    }

    public String getName() {
        return this.name;
    }

    public static VideoAlg of(Integer alg) {
        for (VideoAlg videoAlg : VideoAlg.values()) {
            if (videoAlg.getAlg().equals(alg)) {
                return videoAlg;
            }
        }
        return null;
    }
}
