package cn.com.duiba.tuia.ecb.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 提现状态
 * Created by xuefeng on 2019/4/9.
 */
public enum WithdrawStatus {
    /**
     * 未执行
     */
    INIT(0,"未执行"),

    /**
     * 打款成功
     */
    SUCCESS(1,"打款成功"),

    /**
     * 打款失败
     */
    FAIL(2,"打款失败"),

    /**
     * 未知状态
     */
    UNKNOW(3,"打款未知")
    ;
    private static final Map<Integer, WithdrawStatus> CACHE = Maps.uniqueIndex(Arrays.asList(WithdrawStatus
            .values()), WithdrawStatus::getCode);

    private Integer code;
    private String desc;

    WithdrawStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static WithdrawStatus of(Integer aCode) {
        return CACHE.get(aCode);
    }
}
