package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.*;

import java.util.List;

/**
 * 媒体-广告位
 * Created by xuefeng on 2019/5/22.
 */
@AdvancedFeignClient
public interface RemoteMediaService {

    /**
     * 查询 审核通过&开启 的广告位
     * @return
     */
    List<MediaAppDto> getUseAbleApps();

    /**
     * 查询 审核通过&开启 的广告位
     * @return
     */
    List<MediaSlotDto> getUseAbleSlots();

    /**
     * 分页查询app
     * @return
     */
    PageQueryResultDto<MediaAppDto> getAppList(MediaAppQuery mediaAppQuery);

    /**
     * 更新媒体app
     * @param mediaAppDto
     * @return
     */
    Boolean updateMediaApp(MediaAppDto mediaAppDto);

    /**
     * 分页查询slot
     * @return
     */
    PageQueryResultDto<MediaSlotDto> getSlotList(MediaSlotQuery mediaSlotQuery);

    /**
     * 更新媒体app
     * @param mediaSlotDto
     * @return
     */
    Boolean updateMediaSlot(MediaSlotDto mediaSlotDto);

    /**
     * 根据appId查询广告位
     * @param appId
     * @return
     */
    List<MediaSlotDto> getSlotsByAppId(Long appId);

    /**
     * 根据appids获取媒体信息
     * @param appIds
     * @return
     */
    List<MediaAppDto> getByAppIds(List<Long> appIds);

    /**
     * 根据appkey查询app配置
     * @param appKey
     * @return
     */
    MediaAppDto getByAppKey(String appKey);
}
