package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.dto.PageQueryResultDto;
import cn.com.duiba.tuia.ecb.center.dto.UserWithdrawDetailDto;
import cn.com.duiba.tuia.ecb.center.dto.WithdrawOrderDto;
import cn.com.duiba.tuia.ecb.center.dto.WithdrawQueryDto;
import cn.com.duiba.tuia.ecb.center.exception.EcbCenterException;
import cn.com.duiba.tuia.ecb.center.req.WithdrawApplyReq;

import java.util.List;
import java.util.Map;

/**
 * 提现
 * Created by xuefeng on 2019/4/8.
 */
@AdvancedFeignClient
public interface RemoteWithdrawService {

    /**
     * 提现申请
     * @param withdrawApplyReq
     * @return
     */
    Long apply(WithdrawApplyReq withdrawApplyReq);

    /**
     * 根据流水ids审批
     * @param serialNumbers
     * @return
     */
    Boolean batchPass(List<Long> serialNumbers) throws BizException;

    /**
     * 通过零钱流水号查询订单
     *
     * @param changeSerialNumbers
     * @return map中key为零钱流水号，value为订单详情；不包括不存在的记录
     */
    Map<Long, WithdrawOrderDto> queryByChangeSerialNumber(List<Long> changeSerialNumbers);

    /**
     * 查询用户的新人提现次数
     * @param userId
     * @return
     */
    Integer queryOrderCountForNew(Long userId);

    /**
     * 查询用户的新人提现次数
     * @param userId
     * @param withdrawStatus
     * @return
     */
    Integer queryOrderCountByStatus(Long userId, Integer withdrawStatus);

    /**
     * 分页查询提现订单列表
     *
     * @param queryDto 查询对象
     * @return 订单列表
     */
    PageQueryResultDto<WithdrawOrderDto> pageQuery(WithdrawQueryDto queryDto);

    /**
     * 用户提现详情
     *
     * @param userId
     * @return
     */
    UserWithdrawDetailDto queryUserWithdrawDetail(Long userId) throws BizException;

    /**
     * 批量驳回
     *
     * @param serialNumbers 订单号列表
     * @return
     */
    Boolean batchTurnDown(List<Long> serialNumbers, String turnDwonNote) throws BizException;

    /**
     * 批量拒绝
     *
     * @param serialNumbers 订单号列表
     * @return
     */
    Boolean batchReject(List<Long> serialNumbers) throws BizException;

    /**
     * 通过
     *
     * @param serialNumber 订单号
     * @return
     */
    Boolean pass(Long serialNumber) throws BizException;

    /**
     * 驳回
     *
     * @param serialNumber 订单号
     * @return
     */
    Boolean turnDown(Long serialNumber, String turnDwonNote) throws BizException;

    /**
     * 拒绝
     *
     * @param serialNumber 订单号
     * @return
     */
    Boolean reject(Long serialNumber) throws BizException;

    /**
     * 获取提现订单列表
     *
     * @param queryDto 查询条件对象
     * @return 订单列表
     */
    List<WithdrawOrderDto> list(WithdrawQueryDto queryDto);

    /**
     * 添加备注
     * @param serialNumber
     * @param mark
     * @return
     */
    Boolean addMark(Long serialNumber, String mark);
}
